<?php

namespace Import\ApiBundle\Repository;

use Doctrine\ORM\EntityRepository;
use Import\ApiBundle\Entity\GpwIndex;

/**
 * GpwIndexRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class GpwIndexRepository extends EntityRepository
{
    /**
     * create new NewConnect
     *
     * @param $data
     * @return GpwIndex
     */
    public function add($data)
    {
        $GpwIndex = new GpwIndex();
        $GpwIndex->setSymbol($data['symbol']);
        $GpwIndex->setType($data['GpwType']);

        if(isset($data['name']))
        {
            $GpwIndex->setName($data['name']);
        }

        $this->getEntityManager()->persist($GpwIndex);

        return $GpwIndex;
    }

    public function getGpwIndexForType($typeSymbol)
    {
        $QueryBuilder = $this->createQueryBuilder('i');
        $QueryBuilder
            ->leftJoin('i.type','t')
            ->where($QueryBuilder->expr()->like('t.symbol',$QueryBuilder->expr()->literal($typeSymbol)))
            ->select('i')
        ;
        return $QueryBuilder->getQuery()->getResult();
    }
}
